// PROJECT:       Micro-Manager
// SUBSYSTEM:     MMCore
//
// COPYRIGHT:     University of California, San Francisco, 2014,
//                All Rights reserved
//
// LICENSE:       This file is distributed under the "Lesser GPL" (LGPL) license.
//                License text is included with the source distribution.
//
//                This file is distributed in the hope that it will be useful,
//                but WITHOUT ANY WARRANTY; without even the implied warranty
//                of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
//                IN NO EVENT SHALL THE COPYRIGHT OWNER OR
//                CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//                INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES.
//
// AUTHOR:        Mark Tsuchida

#pragma once

#include "DeviceInstanceBase.h"


// 2023.04.25.bp: Adding this statement so we can export (expose) classes to 
//                dynamically linked modules, such as IgorLink.
#if defined(MMLIB_SERVER)
#   define  MMLIB_USAGE   __declspec(dllexport)
#elif defined(MMLIB_CLIENT)
#   define  MMLIB_USAGE   __declspec(dllimport)
#else
#   undef  MMLIB_USAGE   
#endif



#if defined(MMLIB_USAGE)
class    MMLIB_USAGE ImageProcessorInstance : public DeviceInstanceBase<MM::ImageProcessor>
#else
class    ImageProcessorInstance : public DeviceInstanceBase<MM::ImageProcessor>
#endif
//class ImageProcessorInstance : public DeviceInstanceBase<MM::ImageProcessor>
{
public:
   ImageProcessorInstance(CMMCore* core,
         std::shared_ptr<LoadedDeviceAdapter> adapter,
         const std::string& name,
         MM::Device* pDevice,
         DeleteDeviceFunction deleteFunction,
         const std::string& label,
         mm::logging::Logger deviceLogger,
         mm::logging::Logger coreLogger) :
      DeviceInstanceBase<MM::ImageProcessor>(core, adapter, name, pDevice, deleteFunction, label, deviceLogger, coreLogger)
   {}

   int Process(unsigned char* buffer, unsigned width, unsigned height, unsigned byteDepth);
};
